/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.controller;

import com.example.clinic.dto.Booking;
import com.example.clinic.dto.ServiceFilterDTO;
import com.example.clinic.dto.ServiceProviderDTO;
import com.example.clinic.model.ServiceProfile;
import com.example.clinic.service.PateintMedicineService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
public class ServiceProvidersController {
    @Autowired
    PateintMedicineService pateintMedicineService;

    @GetMapping(value={"service/providers"})
    public ResponseEntity<?> serviceProviders() throws Exception {
        List serviceProviders = this.pateintMedicineService.getServiceProviders();
        return ResponseEntity.ok((Object)serviceProviders);
    }

    @GetMapping(value={"service/providers/{type}"})
    public ResponseEntity<?> serviceProvidersByType(@PathVariable(value="type") String type) throws Exception {
        List serviceProviders = this.pateintMedicineService.getServiceProvidersByType(type);
        return ResponseEntity.ok((Object)serviceProviders);
    }

    @PostMapping(value={"search/providers"})
    public ResponseEntity<?> searchProvider(@RequestBody ServiceProviderDTO serviceProviderDTO) throws Exception {
        List serviceProviders = this.pateintMedicineService.searchForProvider(serviceProviderDTO);
        return ResponseEntity.ok((Object)serviceProviders);
    }

    @GetMapping(value={"get/service/{doctorId}"})
    public ResponseEntity<?> getDoctorProfile(@PathVariable(value="doctorId") int doctorId) throws Exception {
        ServiceProfile serviceProviders = this.pateintMedicineService.getDoctorProfile(doctorId);
        return ResponseEntity.ok((Object)serviceProviders);
    }

    @PostMapping(value={"add/reviews/{doctorId}"})
    public ResponseEntity<?> addReview(@PathVariable(value="doctorId") int doctorId, @RequestBody String review) throws Exception {
        this.pateintMedicineService.addReviews(doctorId, review);
        return ResponseEntity.ok((Object)"review added");
    }

    @GetMapping(value={"get/reviews/{doctorId}"})
    public ResponseEntity<?> getReviews(@PathVariable(value="doctorId") int doctorId) throws Exception {
        ServiceProfile serviceProviders = this.pateintMedicineService.getProvidersReviews(doctorId);
        return ResponseEntity.ok((Object)serviceProviders);
    }

    @PostMapping(value={"book/appointment/{doctorId}"})
    public ResponseEntity<?> bookAppointment(@PathVariable(value="doctorId") int doctorId, @RequestBody Booking book) throws Exception {
        ServiceProfile serviceProviders = this.pateintMedicineService.bookAppointment(doctorId, book);
        return ResponseEntity.ok((Object)serviceProviders);
    }

    @PostMapping(value={"book/visit/{doctorId}"})
    public ResponseEntity<?> bookvisit(@PathVariable(value="doctorId") int doctorId, @RequestBody Booking book) throws Exception {
        ServiceProfile serviceProviders = this.pateintMedicineService.bookHomeVisit(doctorId, book);
        return ResponseEntity.ok((Object)serviceProviders);
    }

    @PostMapping(value={"service/filter/{serviceType}"})
    public ResponseEntity<?> filterProvider(@PathVariable(value="serviceType") String serviceType, @RequestBody ServiceFilterDTO serviceFilterDTO) throws Exception {
        List serviceProviders = this.pateintMedicineService.FilterServiceProvider(serviceType, serviceFilterDTO);
        return ResponseEntity.ok((Object)serviceProviders);
    }
}

