/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.model;

import com.example.clinic.model.BloodPressure;
import com.example.clinic.model.BloodRate;
import com.example.clinic.model.BloodSugarRandom;
import com.example.clinic.model.DiagnosesPrimrary;
import com.example.clinic.model.DiagnosesSecondry;
import com.example.clinic.model.FluidBalance;
import com.example.clinic.model.LabReports;
import com.example.clinic.model.NurseNames;
import com.example.clinic.model.OxygenSaturation;
import com.example.clinic.model.PatientMedicine;
import com.example.clinic.model.PatientUploadedFiles;
import com.example.clinic.model.PhysicianTeam;
import com.example.clinic.model.Teritiary;
import com.example.clinic.model.Weight;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="users")
public class User {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    int id;
    @Column(name="first_name")
    String firstName;
    @Column(name="national_id")
    String nationalId;
    @Column(name="last_name")
    String lastName;
    @Column(name="phone_verified")
    boolean verified;
    @Column(name="email_verified")
    boolean emailVerified;
    @Column(name="full_name_arabic")
    String hospitalId;
    @Column(name="email_address")
    String emailAddress;
    @Column(name="telephone_number")
    String telephoneNumber;
    @Column(name="address")
    String address;
    @Column(name="password")
    String password;
    @Column(name="img")
    @Lob
    byte[] profImg;
    @Column(name="id_card_img")
    @Lob
    byte[] idCard;
    @Column(name="country")
    String country;
    @Column(name="city")
    String city;
    @Column(name="street")
    String street;
    @Column(name="area")
    String area;
    @Column(name="dateOfBirth")
    String dateOfBirth;
    @Column(name="gender")
    String gender;
    @Column(name="age")
    String age;
    @Column(name="skinColor")
    String skinColor;
    @Column(name="weight")
    String weight;
    @Column(name="height")
    String height;
    @Column(name="bsa")
    String bsa;
    @Column(name="bmi")
    String bmi;
    @Column(name="marital_status")
    String maritalStatus;
    @Column(name="language")
    String language;
    @Column(name="race")
    String race;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="userMedicine", orphanRemoval=false, cascade={CascadeType.ALL})
    List<PatientMedicine> patientMedicines;
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="userTeam", orphanRemoval=false)
    PhysicianTeam physicianTeam;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="userPrimaryDiagnose", cascade={CascadeType.ALL}, orphanRemoval=false)
    List<DiagnosesPrimrary> diagnosesPrimary;
    @OneToOne(cascade={CascadeType.REMOVE, CascadeType.ALL}, mappedBy="userNurse", orphanRemoval=false)
    NurseNames nurseNames;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="teritarty", orphanRemoval=false, cascade={CascadeType.ALL})
    List<Teritiary> teritiaryList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="secondaryDiagnoseUser", orphanRemoval=false, cascade={CascadeType.ALL})
    List<DiagnosesSecondry> secondryUser;
    @Column(name="name_kin")
    String nameOfKin;
    @Column(name="clinic_name")
    String clinicName;
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL}, orphanRemoval=false)
    List<BloodPressure> bloodPressure;
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL}, orphanRemoval=false)
    List<BloodRate> bloodRate;
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL}, orphanRemoval=false)
    List<OxygenSaturation> oxygenSaturation;
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL}, orphanRemoval=false)
    List<Weight> weightUser;
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL}, orphanRemoval=false)
    List<BloodSugarRandom> bloodSugarRandom;
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL}, orphanRemoval=false)
    List<FluidBalance> fluidBalance;
    @OneToMany(mappedBy="userReport", cascade={CascadeType.ALL}, orphanRemoval=false)
    List<LabReports> labReports;
    @OneToMany(mappedBy="userFiles", cascade={CascadeType.ALL}, orphanRemoval=false)
    @JsonIgnore
    List<PatientUploadedFiles> patientUploadedFiles;

    public int getId() {
        return this.id;
    }

    public String getRace() {
        return this.race;
    }

    public void setRace(String race) {
        this.race = race;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getHospitalId() {
        return this.hospitalId;
    }

    public void setHospitalId(String hospitalId) {
        this.hospitalId = hospitalId;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getAge() {
        return this.age;
    }

    public void setAge(String age) {
        this.age = age;
    }

    public String getSkinColor() {
        return this.skinColor;
    }

    public void setSkinColor(String skinColor) {
        this.skinColor = skinColor;
    }

    public String getWeight() {
        return this.weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getBsa() {
        return this.bsa;
    }

    public void setBsa(String bsa) {
        this.bsa = bsa;
    }

    public String getBmi() {
        return this.bmi;
    }

    public void setBmi(String bmi) {
        this.bmi = bmi;
    }

    public String getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<Teritiary> getTeritiaryList() {
        return this.teritiaryList;
    }

    public void setTeritiaryList(List<Teritiary> teritiaryList) {
        this.teritiaryList = teritiaryList;
    }

    public String getNameOfKin() {
        return this.nameOfKin;
    }

    public void setNameOfKin(String nameOfKin) {
        this.nameOfKin = nameOfKin;
    }

    public String getClinicName() {
        return this.clinicName;
    }

    public void setClinicName(String clinicName) {
        this.clinicName = clinicName;
    }

    public byte[] getProfImg() {
        return this.profImg;
    }

    public void setProfImg(byte[] profImg) {
        this.profImg = profImg;
    }

    public List<DiagnosesPrimrary> getDiagnosesPrimary() {
        return this.diagnosesPrimary;
    }

    public void setDiagnosesPrimary(List<DiagnosesPrimrary> diagnosesPrimary) {
        this.diagnosesPrimary = diagnosesPrimary;
    }

    public PhysicianTeam getPhysicianTeam() {
        return this.physicianTeam;
    }

    public void setPhysicianTeam(PhysicianTeam physicianTeam) {
        this.physicianTeam = physicianTeam;
    }

    public NurseNames getNurseNames() {
        return this.nurseNames;
    }

    public void setNurseNames(NurseNames nurseNames) {
        this.nurseNames = nurseNames;
    }

    public byte[] getIdCard() {
        return this.idCard;
    }

    public void setIdCard(byte[] idCard) {
        this.idCard = idCard;
    }

    public List<DiagnosesSecondry> getSecondryUser() {
        return this.secondryUser;
    }

    public void setSecondryUser(List<DiagnosesSecondry> secondryUser) {
        this.secondryUser = secondryUser;
    }

    public List<PatientMedicine> getPatientMedicines() {
        return this.patientMedicines;
    }

    public void setPatientMedicines(List<PatientMedicine> patientMedicines) {
        this.patientMedicines = patientMedicines;
    }

    public List<BloodPressure> getBloodPressure() {
        return this.bloodPressure;
    }

    public void setBloodPressure(List<BloodPressure> bloodPressure) {
        this.bloodPressure = bloodPressure;
    }

    public List<BloodRate> getBloodRate() {
        return this.bloodRate;
    }

    public void setBloodRate(List<BloodRate> bloodRate) {
        this.bloodRate = bloodRate;
    }

    public List<OxygenSaturation> getOxygenSaturation() {
        return this.oxygenSaturation;
    }

    public void setOxygenSaturation(List<OxygenSaturation> oxygenSaturation) {
        this.oxygenSaturation = oxygenSaturation;
    }

    public List<Weight> getWeightUser() {
        return this.weightUser;
    }

    public void setWeightUser(List<Weight> weightUser) {
        this.weightUser = weightUser;
    }

    public List<BloodSugarRandom> getBloodSugarRandom() {
        return this.bloodSugarRandom;
    }

    public void setBloodSugarRandom(List<BloodSugarRandom> bloodSugarRandom) {
        this.bloodSugarRandom = bloodSugarRandom;
    }

    public String getNationalId() {
        return this.nationalId;
    }

    public void setNationalId(String nationalId) {
        this.nationalId = nationalId;
    }

    public List<FluidBalance> getFluidBalance() {
        return this.fluidBalance;
    }

    public void setFluidBalance(List<FluidBalance> fluidBalance) {
        this.fluidBalance = fluidBalance;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public void setEmailVerified(boolean emailVerified) {
        this.emailVerified = emailVerified;
    }

    public List<PatientUploadedFiles> getPatientUploadedFiles() {
        return this.patientUploadedFiles;
    }

    public void setPatientUploadedFiles(List<PatientUploadedFiles> patientUploadedFiles) {
        this.patientUploadedFiles = patientUploadedFiles;
    }
}

