/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.service.impl;

import com.example.clinic.dto.CredentialsRequest;
import com.example.clinic.model.OTPValidation;
import com.example.clinic.model.User;
import com.example.clinic.model.UserSession;
import com.example.clinic.repository.LoginRepository;
import com.example.clinic.repository.UserRepository;
import com.example.clinic.service.LoginServices;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.server.ResponseStatusException;

@Service
public class LoginServicesImpl
implements LoginServices {
    String token = null;
    @Autowired
    UserRepository userRepository;
    @Autowired
    LoginRepository loginRepository;
    @Autowired
    private JavaMailSender javaMailSender;

    public void logout(String email) {
        this.userRepository.deleteToken(email);
    }

    public UserSession loginProcess(CredentialsRequest studentCreateRequest) {
        UserSession studentSession = new UserSession();
        Optional student = this.userRepository.findByUsername(studentCreateRequest.getEmailAddress());
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        if (encoder.matches((CharSequence)studentCreateRequest.getPassword(), ((User)student.get()).getPassword())) {
            studentSession.setSessionId(UUID.randomUUID().toString());
            studentSession.setPhoneNumber(studentCreateRequest.getUserName());
            studentSession.setToken(studentCreateRequest.getToken());
            studentSession.setPhoneNumber(studentCreateRequest.getPhoneNumber());
            studentSession.setEmailAddress(studentCreateRequest.getEmailAddress());
            this.loginRepository.removeSession(studentCreateRequest.getEmailAddress());
            return this.loginRepository.saveAuthentication(studentSession);
        }
        throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "wrong password");
    }

    public String getUserByUserName(String email) {
        return ((User)this.userRepository.findByemailAddress(email).get()).getEmailAddress();
    }

    public void verifyEmail(String emailAdress) {
        Optional user = this.userRepository.findByemailAddress(emailAdress);
        String regex = "^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(emailAdress);
        if (!matcher.matches()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Not Valid E-mail format");
        }
        if (user.isPresent() && ObjectUtils.isEmpty(user.get())) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Not Found Email");
        }
        String numbers = "0123456789";
        Random random = new Random();
        StringBuilder otp = new StringBuilder(4);
        for (int i = 0; i < 4; ++i) {
            otp.append(numbers.charAt(random.nextInt(numbers.length())));
        }
        String otpMesage = "This code is valid for a short time. Do not share it with anyone.Important: Never share this code with anyone, even if they claim to be from our support team.If you did not initiate this request, please ignore this email.Thank you    ";
        SimpleMailMessage message = new SimpleMailMessage();
        message.setTo(emailAdress);
        message.setFrom("info@capitalheartclinic.com");
        message.setSubject("edit-password-Capital-Heart-Clinic-OTP");
        message.setText(otpMesage + "OTP:   " + otp.toString());
        OTPValidation otpValidation = new OTPValidation();
        otpValidation.setOtp(String.valueOf(otp));
        otpValidation.setEmailAddress(emailAdress);
        otpValidation.setSent(true);
        this.loginRepository.saveOtp(otpValidation);
        this.javaMailSender.send(message);
    }
}

