/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.service.impl;

import com.example.clinic.dto.MessageCenterDTO;
import com.example.clinic.dto.UserCreateRequest;
import com.example.clinic.model.DiagnosesPrimrary;
import com.example.clinic.model.DiagnosesSecondry;
import com.example.clinic.model.MessageCenter;
import com.example.clinic.model.NurseNames;
import com.example.clinic.model.PhysicianTeam;
import com.example.clinic.model.Teritiary;
import com.example.clinic.model.User;
import com.example.clinic.model.nurse;
import com.example.clinic.model.primarydiag;
import com.example.clinic.model.secondary;
import com.example.clinic.model.team;
import com.example.clinic.model.tretary;
import com.example.clinic.repository.LoginRepository;
import com.example.clinic.repository.MessageCenterRepository;
import com.example.clinic.repository.UserRepository;
import com.example.clinic.service.MessageCenterService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageCenterServiceImpl
implements MessageCenterService {
    @Autowired
    MessageCenterRepository messageCenterRepository;
    @Autowired
    LoginRepository loginRepository;
    @Autowired
    UserRepository userRepository;

    public MessageCenter addMessage(MessageCenterDTO messageCenterDTO) {
        MessageCenter messageCenter = new MessageCenter();
        if (messageCenterDTO.getMessage().isEmpty()) {
            messageCenter.setMessage("n/a");
        } else {
            messageCenter.setMessage(messageCenterDTO.getMessage());
        }
        if (messageCenterDTO.getName().isEmpty()) {
            messageCenter.setName("n/a");
        } else {
            messageCenter.setName(messageCenterDTO.getName());
        }
        if (messageCenterDTO.getSubject().isEmpty()) {
            messageCenter.setSubject("n/a");
        } else {
            messageCenter.setSubject(messageCenterDTO.getSubject());
        }
        if (messageCenterDTO.getEmailAddress().isEmpty()) {
            messageCenter.setEmailAddress("n/a");
        } else {
            messageCenter.setEmailAddress(messageCenterDTO.getEmailAddress());
        }
        messageCenter.setStatus(true);
        messageCenter.setRead("notRead");
        return this.messageCenterRepository.addMessage(messageCenter);
    }

    public Optional<MessageCenter> getMessage(String emailAddress) {
        return this.messageCenterRepository.getMessage(emailAddress);
    }

    public boolean getMessageStatus(String email) {
        return this.messageCenterRepository.getMessageStatus(email);
    }

    public void getMessageWithStatusUpdate(String email, int id) {
        this.messageCenterRepository.updateStatus(email, id);
    }

    public User updateUserDetails(UserCreateRequest userCreateRequest, int userid) {
        NurseNames nurseNamesoffset;
        User userForUpdate = (User)this.userRepository.findById(userid).get();
        if (userCreateRequest.getAge() != null) {
            userForUpdate.setAge(userCreateRequest.getAge());
        }
        if (userCreateRequest.getFirstName() != null) {
            userForUpdate.setFirstName(userCreateRequest.getFirstName());
        }
        if (userCreateRequest.getAddress() != null) {
            userForUpdate.setAddress(userCreateRequest.getAddress());
        }
        if (userCreateRequest.getEmailAddress() != null) {
            userForUpdate.setEmailAddress(userCreateRequest.getEmailAddress());
        }
        if (userCreateRequest.getTelephoneNumber() != null) {
            userForUpdate.setTelephoneNumber(userCreateRequest.getTelephoneNumber());
        }
        if (userCreateRequest.getClinicName() != null) {
            userForUpdate.setClinicName(userCreateRequest.getClinicName());
        }
        if (userCreateRequest.getHospitalId() != null) {
            userForUpdate.setHospitalId(userCreateRequest.getHospitalId());
        }
        if (userCreateRequest.getLastName() != null) {
            userForUpdate.setLastName(userCreateRequest.getLastName());
        }
        if (userCreateRequest.getArea() != null) {
            userForUpdate.setArea(userCreateRequest.getArea());
        }
        if (userCreateRequest.getBmi() != null) {
            userForUpdate.setBmi(userCreateRequest.getBmi());
        }
        if (userCreateRequest.getCity() != null) {
            userForUpdate.setCity(userCreateRequest.getCity());
        }
        if (userCreateRequest.getBsa() != null) {
            userForUpdate.setBsa(userCreateRequest.getBsa());
        }
        if (userCreateRequest.getClinicName() != null) {
            userForUpdate.setClinicName(userCreateRequest.getClinicName());
        }
        if (userCreateRequest.getCountry() != null) {
            userForUpdate.setCountry(userCreateRequest.getCountry());
        }
        if (userCreateRequest.getDateOfBirth() != null) {
            userForUpdate.setDateOfBirth(userCreateRequest.getDateOfBirth());
        }
        if (userCreateRequest.getRace() != null) {
            userForUpdate.setRace(userCreateRequest.getRace());
        }
        if (userCreateRequest.getDiagnosesPrimary() != null) {
            this.userRepository.deleteprimarydig(userForUpdate.getId());
            for (String result : userCreateRequest.getDiagnosesPrimary()) {
                this.userRepository.addPrimary(new DiagnosesPrimrary(result, userForUpdate));
            }
        }
        if (userCreateRequest.getDiagnosesSecondary() != null) {
            this.userRepository.deletesec(userForUpdate.getId());
            for (String result : userCreateRequest.getDiagnosesSecondary()) {
                this.userRepository.secondaryDiag(new DiagnosesSecondry(result, userForUpdate));
            }
        }
        if (userCreateRequest.getGender() != null) {
            userForUpdate.setGender(userCreateRequest.getGender());
        }
        if (userCreateRequest.getHeight() != null) {
            userForUpdate.setHeight(userCreateRequest.getHeight());
        }
        if (userCreateRequest.getIdCard() != null) {
            userForUpdate.setIdCard(userCreateRequest.getIdCard());
        }
        if (userCreateRequest.getProfImg() != null) {
            userForUpdate.setProfImg(userCreateRequest.getProfImg());
        }
        if (userCreateRequest.getLanguage() != null) {
            userForUpdate.setLanguage(userCreateRequest.getLanguage());
        }
        if (userCreateRequest.getMaritalStatus() != null) {
            userForUpdate.setMaritalStatus(userCreateRequest.getMaritalStatus());
        }
        if (userCreateRequest.getNameOfKin() != null) {
            userForUpdate.setNameOfKin(userCreateRequest.getNameOfKin());
        }
        if (userCreateRequest.getSkinColor() != null) {
            userForUpdate.setSkinColor(userCreateRequest.getSkinColor());
        }
        if (userCreateRequest.getWeight() != null) {
            userForUpdate.setWeight(userCreateRequest.getWeight());
        }
        if (userCreateRequest.getStreet() != null) {
            userForUpdate.setStreet(userCreateRequest.getStreet());
        }
        if (userCreateRequest.getNationalId() != null) {
            userForUpdate.setNationalId(userCreateRequest.getNationalId());
        }
        if (userCreateRequest.getTeritiaryList() != null) {
            this.userRepository.deleteter(userForUpdate.getId());
            for (String result : userCreateRequest.getTeritiaryList()) {
                this.userRepository.tretaty(new Teritiary(result, userForUpdate));
            }
        }
        if (userCreateRequest.getNurseNames() != null) {
            nurseNamesoffset = new NurseNames();
            nurseNamesoffset.setUserNurse(userForUpdate);
            nurseNamesoffset.setName(userCreateRequest.getNurseNames());
            this.userRepository.deltenurse(userForUpdate.getId());
            this.userRepository.savenurse(nurseNamesoffset);
        }
        if (userCreateRequest.getPhysicianTeam() != null) {
            this.userRepository.deleteteam(userForUpdate.getId());
            nurseNamesoffset = new PhysicianTeam();
            nurseNamesoffset.setUserTeam(userForUpdate);
            nurseNamesoffset.setName(userCreateRequest.getPhysicianTeam());
            this.userRepository.savePhysican((PhysicianTeam)nurseNamesoffset);
        }
        this.userRepository.registerUser(userForUpdate);
        return userForUpdate;
    }

    public List<secondary> getSecondaryDiagnose() {
        return this.messageCenterRepository.getSecondryDiagnose();
    }

    public List<team> getPhysicianteam() {
        return this.messageCenterRepository.getPhysicianTeam();
    }

    public List<nurse> getNursenames() {
        return this.messageCenterRepository.getNursesName();
    }

    public List<tretary> getTeritaryList() {
        return this.messageCenterRepository.getTeritary();
    }

    public List<primarydiag> getPrimaryDiagnose() {
        return this.messageCenterRepository.getPrimaryDiagnose();
    }

    public long getMessageCounts(String name) {
        return this.messageCenterRepository.getUnreadMessageCounts(name);
    }

    public Optional<MessageCenter> getMessageALL(String name) {
        return this.messageCenterRepository.getAllMessages(name);
    }

    public MessageCenter getSinglMessage(String name, int id) {
        return this.messageCenterRepository.getSingleMesage(name, id);
    }

    public void AllMessageWithStatusUpdate(String name) {
        this.messageCenterRepository.updateAllesagesstatus(name);
    }
}

