/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.service.impl;

import com.example.clinic.dto.BloodPressureDTO;
import com.example.clinic.dto.Filter;
import com.example.clinic.dto.FilterImages;
import com.example.clinic.dto.ImagesRequestDTO;
import com.example.clinic.model.BloodPressure;
import com.example.clinic.model.BloodRate;
import com.example.clinic.model.BloodSugarRandom;
import com.example.clinic.model.FluidBalance;
import com.example.clinic.model.Images;
import com.example.clinic.model.OxygenSaturation;
import com.example.clinic.model.PDFS;
import com.example.clinic.model.PatientUploadedFiles;
import com.example.clinic.model.Symptoms;
import com.example.clinic.model.User;
import com.example.clinic.model.Weight;
import com.example.clinic.repository.OverViewRepository;
import com.example.clinic.repository.SymtompsRepository;
import com.example.clinic.repository.UserRepository;
import com.example.clinic.service.OverViewService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class OverViewServiceImpl
implements OverViewService {
    @Autowired
    UserRepository userRepository;
    @Autowired
    SymtompsRepository symtompsRepository;
    @Autowired
    OverViewRepository overViewRepository;

    public List<Symptoms> getSymtompsList() {
        return this.symtompsRepository.getSymtomps();
    }

    public void addBloodPressure(BloodPressureDTO bloodPressureDTO) {
        String formattedDate;
        DateTimeFormatter formatter;
        LocalDateTime now;
        String formattedDate2;
        DateTimeFormatter formatter2;
        BloodPressure bloodPressure = new BloodPressure();
        bloodPressure.setDbp(bloodPressureDTO.getDbp());
        bloodPressure.setHeartRate(bloodPressureDTO.getHeartRate());
        bloodPressure.setSbp(bloodPressureDTO.getSbp());
        if (bloodPressureDTO.getSymtopms().equalsIgnoreCase("other")) {
            bloodPressure.setSymtopms(bloodPressureDTO.getSymtopmText());
        } else {
            bloodPressure.setSymtopms(bloodPressureDTO.getSymtopms());
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userName = authentication.getName();
        User user = (User)this.userRepository.findByemailAddress(userName).get();
        bloodPressure.setUser(user);
        double meanPressure = (bloodPressureDTO.getSbp() + bloodPressureDTO.getDbp()) / 2.0;
        bloodPressure.setMeanBloodPressure(meanPressure);
        if (bloodPressureDTO.getDate() != null) {
            formatter2 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            formattedDate2 = formatter2.format(bloodPressureDTO.getDate());
            bloodPressure.setDate(formattedDate2);
        } else {
            now = LocalDateTime.now();
            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            formattedDate = formatter.format(now);
            bloodPressure.setDate(formattedDate);
        }
        if (bloodPressureDTO.getTime() != null) {
            formatter2 = DateTimeFormatter.ofPattern(" HH:mm:ss");
            formattedDate2 = formatter2.format(bloodPressureDTO.getTime());
            bloodPressure.setTime(formattedDate2);
        } else {
            now = LocalDateTime.now();
            formatter = DateTimeFormatter.ofPattern(" HH:mm:ss");
            formattedDate = formatter.format(now);
            bloodPressure.setTime(formattedDate);
        }
        bloodPressure.setType("bloodPressure");
        this.overViewRepository.addBloodPressure(bloodPressure);
    }

    public void addBloodRate(BloodPressureDTO bloodPressureDTO) {
        String formattedDate;
        DateTimeFormatter formatter;
        LocalDateTime now;
        String formattedDate2;
        DateTimeFormatter formatter2;
        BloodRate bloodRate = new BloodRate();
        bloodRate.setHeartRate(bloodPressureDTO.getHeartRate());
        if (bloodPressureDTO.getSymtopms().equalsIgnoreCase("other")) {
            bloodRate.setSymtopms(bloodPressureDTO.getSymtopmText());
        } else {
            bloodRate.setSymtopms(bloodPressureDTO.getSymtopms());
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userName = authentication.getName();
        User user = (User)this.userRepository.findByemailAddress(userName).get();
        bloodRate.setUser(user);
        if (bloodPressureDTO.getDate() != null) {
            formatter2 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            formattedDate2 = formatter2.format(bloodPressureDTO.getDate());
            bloodRate.setDate(formattedDate2);
        } else {
            now = LocalDateTime.now();
            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            formattedDate = formatter.format(now);
            bloodRate.setDate(formattedDate);
        }
        if (bloodPressureDTO.getTime() != null) {
            formatter2 = DateTimeFormatter.ofPattern(" HH:mm:ss");
            formattedDate2 = formatter2.format(bloodPressureDTO.getTime());
            bloodRate.setTime(formattedDate2);
        } else {
            now = LocalDateTime.now();
            formatter = DateTimeFormatter.ofPattern(" HH:mm:ss");
            formattedDate = formatter.format(now);
            bloodRate.setTime(formattedDate);
        }
        bloodRate.setType("bloodRate");
        this.overViewRepository.addBloodRate(bloodRate);
    }

    public void addOxegynSaturation(BloodPressureDTO bloodPressureDTO) {
        String formattedDate;
        DateTimeFormatter formatter;
        LocalDateTime now;
        String formattedDate2;
        DateTimeFormatter formatter2;
        OxygenSaturation oxygenSaturation = new OxygenSaturation();
        if (bloodPressureDTO.getSymtopms().equalsIgnoreCase("other")) {
            oxygenSaturation.setSymtopms(bloodPressureDTO.getSymtopmText());
        } else {
            oxygenSaturation.setSymtopms(bloodPressureDTO.getSymtopms());
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userName = authentication.getName();
        User user = (User)this.userRepository.findByemailAddress(userName).get();
        oxygenSaturation.setUser(user);
        if (bloodPressureDTO.getDate() != null) {
            formatter2 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            formattedDate2 = formatter2.format(bloodPressureDTO.getDate());
            oxygenSaturation.setDate(formattedDate2);
        } else {
            now = LocalDateTime.now();
            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            formattedDate = formatter.format(now);
            oxygenSaturation.setDate(formattedDate);
        }
        if (bloodPressureDTO.getTime() != null) {
            formatter2 = DateTimeFormatter.ofPattern(" HH:mm:ss");
            formattedDate2 = formatter2.format(bloodPressureDTO.getTime());
            oxygenSaturation.setTime(formattedDate2);
        } else {
            now = LocalDateTime.now();
            formatter = DateTimeFormatter.ofPattern(" HH:mm:ss");
            formattedDate = formatter.format(now);
            oxygenSaturation.setTime(formattedDate);
        }
        oxygenSaturation.setType("oxygenSaturation");
        oxygenSaturation.setBloodSaturation(bloodPressureDTO.getOxygenSaturation() + " %");
        oxygenSaturation.setOxogynDeliveryMethod(bloodPressureDTO.getOxygenDeliveryMethod());
        this.overViewRepository.addOxygenSaturation(oxygenSaturation);
    }

    public void addWeight(BloodPressureDTO bloodPressureDTO) {
        String formattedDate;
        DateTimeFormatter formatter;
        LocalDateTime now;
        String formattedDate2;
        DateTimeFormatter formatter2;
        Weight weight = new Weight();
        if (bloodPressureDTO.getSymtopms().equalsIgnoreCase("other")) {
            weight.setSymtopms(bloodPressureDTO.getSymtopmText());
        } else {
            weight.setSymtopms(bloodPressureDTO.getSymtopms());
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userName = authentication.getName();
        User user = (User)this.userRepository.findByemailAddress(userName).get();
        weight.setUser(user);
        if (bloodPressureDTO.getDate() != null) {
            formatter2 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            formattedDate2 = formatter2.format(bloodPressureDTO.getDate());
            weight.setDate(formattedDate2);
        } else {
            now = LocalDateTime.now();
            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            formattedDate = formatter.format(now);
            weight.setDate(formattedDate);
        }
        if (bloodPressureDTO.getTime() != null) {
            formatter2 = DateTimeFormatter.ofPattern(" HH:mm:ss");
            formattedDate2 = formatter2.format(bloodPressureDTO.getTime());
            weight.setTime(formattedDate2);
        } else {
            now = LocalDateTime.now();
            formatter = DateTimeFormatter.ofPattern(" HH:mm:ss");
            formattedDate = formatter.format(now);
            weight.setTime(formattedDate);
        }
        weight.setType("weight");
        weight.setWeight(bloodPressureDTO.getWeight());
        double heightToBMI = Double.parseDouble(user.getHeight());
        heightToBMI /= 100.0;
        heightToBMI *= heightToBMI;
        double bmi = bloodPressureDTO.getWeight() / heightToBMI;
        weight.setBmi(bmi);
        this.overViewRepository.addWeight(weight);
    }

    public void addRandomSugar(BloodPressureDTO bloodPressureDTO) {
        String formattedDate;
        DateTimeFormatter formatter;
        LocalDateTime now;
        String formattedDate2;
        DateTimeFormatter formatter2;
        BloodSugarRandom bloodSugarRandom = new BloodSugarRandom();
        if (bloodPressureDTO.getSymtopms().equalsIgnoreCase("other")) {
            bloodSugarRandom.setSymtopms(bloodPressureDTO.getSymtopmText());
        } else {
            bloodSugarRandom.setSymtopms(bloodPressureDTO.getSymtopms());
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userName = authentication.getName();
        User user = (User)this.userRepository.findByemailAddress(userName).get();
        bloodSugarRandom.setUser(user);
        if (bloodPressureDTO.getDate() != null) {
            formatter2 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            formattedDate2 = formatter2.format(bloodPressureDTO.getDate());
            bloodSugarRandom.setDate(formattedDate2);
        } else {
            now = LocalDateTime.now();
            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            formattedDate = formatter.format(now);
            bloodSugarRandom.setDate(formattedDate);
        }
        if (bloodPressureDTO.getTime() != null) {
            formatter2 = DateTimeFormatter.ofPattern(" HH:mm:ss");
            formattedDate2 = formatter2.format(bloodPressureDTO.getTime());
            bloodSugarRandom.setTime(formattedDate2);
        } else {
            now = LocalDateTime.now();
            formatter = DateTimeFormatter.ofPattern(" HH:mm:ss");
            formattedDate = formatter.format(now);
            bloodSugarRandom.setTime(formattedDate);
        }
        bloodSugarRandom.setType("bloodSugar");
        bloodSugarRandom.setRandomBloodSugar(bloodPressureDTO.getBloodSugarRandom());
        bloodSugarRandom.setInsulineDose(bloodPressureDTO.getInsulineDose());
        this.overViewRepository.addBloodSugarRandom(bloodSugarRandom);
    }

    public void addFluid(BloodPressureDTO bloodPressureDTO) {
        String formattedDate;
        DateTimeFormatter formatter;
        LocalDateTime now;
        String formattedDate2;
        DateTimeFormatter formatter2;
        FluidBalance fluidBalance = new FluidBalance();
        if (bloodPressureDTO.getSymtopms().equalsIgnoreCase("other")) {
            fluidBalance.setSymtopms(bloodPressureDTO.getSymtopmText());
        } else {
            fluidBalance.setSymtopms(bloodPressureDTO.getSymtopms());
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userName = authentication.getName();
        User user = (User)this.userRepository.findByemailAddress(userName).get();
        fluidBalance.setUser(user);
        if (bloodPressureDTO.getDate() != null) {
            formatter2 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            formattedDate2 = formatter2.format(bloodPressureDTO.getDate());
            fluidBalance.setDate(formattedDate2);
        } else {
            now = LocalDateTime.now();
            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            formattedDate = formatter.format(now);
            fluidBalance.setDate(formattedDate);
        }
        if (bloodPressureDTO.getTime() != null) {
            formatter2 = DateTimeFormatter.ofPattern(" HH:mm:ss");
            formattedDate2 = formatter2.format(bloodPressureDTO.getTime());
            fluidBalance.setTime(formattedDate2);
        } else {
            now = LocalDateTime.now();
            formatter = DateTimeFormatter.ofPattern(" HH:mm:ss");
            formattedDate = formatter.format(now);
            fluidBalance.setTime(formattedDate);
        }
        fluidBalance.setType("fluidBalance");
        fluidBalance.setFluidIn(bloodPressureDTO.getFluidIn());
        fluidBalance.setFluidOut(bloodPressureDTO.getFluidOut());
        fluidBalance.setTotalFluid(bloodPressureDTO.getFluidIn() + bloodPressureDTO.getFluidOut());
        double net = bloodPressureDTO.getFluidIn() - bloodPressureDTO.getFluidOut();
        if (net < 0.0) {
            net = Math.abs(net);
        }
        fluidBalance.setFluidNet(net);
        this.overViewRepository.addFluidBalance(fluidBalance);
    }

    public List<Object> filter(Filter filter) {
        ArrayList<Object> result = new ArrayList<Object>();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userName = authentication.getName();
        User user = (User)this.userRepository.findByemailAddress(userName).get();
        if (filter.getType() != null && filter.getDateTo() == null && filter.getDateFrom() == null) {
            result.add(this.overViewRepository.getbloodPressureByDBP(user.getId()));
        }
        if (filter.getType2() != null && filter.getDateTo() == null && filter.getDateFrom() == null) {
            result.add(this.overViewRepository.getHeartRate(user.getId()));
        }
        if (filter.getType3() != null && filter.getDateTo() == null && filter.getDateFrom() == null) {
            result.add(this.overViewRepository.getOxygenSaturation(user.getId()));
        }
        if (filter.getType4() != null && filter.getDateTo() == null && filter.getDateFrom() == null) {
            result.add(this.overViewRepository.getBloodSugarLevel(user.getId()));
        }
        if (filter.getType5() != null && filter.getDateTo() == null && filter.getDateFrom() == null) {
            result.add(this.overViewRepository.getFluidRange(user.getId()));
        }
        if (filter.getType6() != null && filter.getDateTo() == null && filter.getDateFrom() == null) {
            result.add(this.overViewRepository.getWeight(user.getId()));
        }
        if (filter.getType() != null && filter.getDateTo() != null && filter.getDateFrom() != null) {
            result.add(this.overViewRepository.getbloodPressureByDBPdates(user.getId(), filter.getDateFrom(), filter.getDateTo()));
        }
        if (filter.getType2() != null && filter.getDateTo() != null && filter.getDateFrom() != null) {
            result.add(this.overViewRepository.getHeartRatedates(user.getId(), filter.getDateFrom(), filter.getDateTo()));
        }
        if (filter.getType3() != null && filter.getDateTo() != null && filter.getDateFrom() != null) {
            result.add(this.overViewRepository.getOxygenSaturationdates(user.getId(), filter.getDateFrom(), filter.getDateTo()));
        }
        if (filter.getType4() != null && filter.getDateTo() != null && filter.getDateFrom() != null) {
            result.add(this.overViewRepository.getBloodSugarLeveldates(user.getId(), filter.getDateFrom(), filter.getDateTo()));
        }
        if (filter.getType5() != null && filter.getDateTo() != null && filter.getDateFrom() != null) {
            result.add(this.overViewRepository.getFluidRangedate(user.getId(), filter.getDateFrom(), filter.getDateTo()));
        }
        if (filter.getType6() != null && filter.getDateTo() != null && filter.getDateFrom() != null) {
            result.add(this.overViewRepository.getWeightdates(user.getId(), filter.getDateFrom(), filter.getDateTo()));
        }
        return result;
    }

    public void uploadFiles(ImagesRequestDTO imagesRequestDTO) {
        Images images = new Images();
        ArrayList imagesList = new ArrayList();
        ArrayList<PDFS> pdfs = new ArrayList<PDFS>();
        PDFS p = new PDFS();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String email = authentication.getName();
        User user = (User)this.userRepository.findByemailAddress(email).get();
        PatientUploadedFiles patientUploadedFiles = new PatientUploadedFiles();
        patientUploadedFiles.setUserFiles(user);
        patientUploadedFiles.setImgs(imagesList);
        patientUploadedFiles.setFolderName(imagesRequestDTO.getFolderName());
        String date = null;
        if (imagesRequestDTO.getDate() == null) {
            LocalDate today = LocalDate.now();
            DateTimeFormatter customFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
            date = today.format(customFormatter);
        } else {
            date = imagesRequestDTO.getDate();
        }
        patientUploadedFiles.setDate(date);
        PatientUploadedFiles patientUploadedFilesSaved = this.overViewRepository.addImages(patientUploadedFiles);
        for (byte[] resutl : imagesRequestDTO.getImages()) {
            images.setImgs(resutl);
            images.setPatientUploadedFiles(patientUploadedFilesSaved);
            images.setUserId(user.getId());
            this.overViewRepository.addImagesFles(images);
        }
        PatientUploadedFiles addingRest = this.overViewRepository.getImagesById(patientUploadedFilesSaved.getId());
        if (!imagesRequestDTO.getPdfs().isEmpty()) {
            for (byte[] result : imagesRequestDTO.getPdfs()) {
                p.setImgs(result);
                p.setUserId(user.getId());
                p.setLabReports(addingRest);
                pdfs.add(p);
            }
        }
        addingRest.setPdfs(pdfs);
        this.overViewRepository.addImages(addingRest);
    }

    public List<PatientUploadedFiles> filterImage(FilterImages filterImages) {
        ArrayList<PatientUploadedFiles> patientUploadedFilesList = new ArrayList<PatientUploadedFiles>();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String email = authentication.getName();
        User user = (User)this.userRepository.findByemailAddress(email).get();
        if (filterImages.getDateTo() != null && filterImages.getDateFrom() != null && filterImages.getOrdering() == null && filterImages.getFolderName() == null) {
            patientUploadedFilesList.addAll(this.overViewRepository.getPatientFilesByDateFroAndTo(user.getId(), filterImages.getDateFrom(), filterImages.getDateTo()));
        }
        if (filterImages.getDateTo() == null && filterImages.getDateFrom() == null && filterImages.getOrdering() != null && filterImages.getFolderName() == null) {
            if (filterImages.getOrdering().equalsIgnoreCase("Newest First")) {
                patientUploadedFilesList.addAll(this.overViewRepository.getPatientFilesByDesc(user.getId()));
            } else {
                patientUploadedFilesList.addAll(this.overViewRepository.getPatientFilesByAsc(user.getId()));
            }
        }
        if (filterImages.getFolderName() != null && filterImages.getOrdering() == null && filterImages.getDateTo() == null && filterImages.getDateFrom() == null) {
            patientUploadedFilesList.addAll(this.overViewRepository.getPatientFilesByType(user.getId(), filterImages.getFolderName()));
        }
        if (filterImages.getDateTo() != null && filterImages.getDateFrom() != null && filterImages.getOrdering() != null && filterImages.getFolderName() != null) {
            if (filterImages.getOrdering().equals("Newest First")) {
                patientUploadedFilesList.addAll(this.overViewRepository.getPatientFilesBYALL(user.getId(), filterImages.getDateFrom(), filterImages.getDateTo(), filterImages.getOrdering(), filterImages.getFolderName()));
            } else {
                patientUploadedFilesList.addAll(this.overViewRepository.getPatientFilesByALlAsc(user.getId(), filterImages.getDateFrom(), filterImages.getDateTo(), filterImages.getOrdering(), filterImages.getFolderName()));
            }
        }
        if (filterImages.getDateTo() != null && filterImages.getDateFrom() != null && filterImages.getOrdering() == null && filterImages.getFolderName() != null) {
            patientUploadedFilesList.addAll(this.overViewRepository.getPatientFilesBYALLNotOrdering(user.getId(), filterImages.getDateFrom(), filterImages.getDateTo(), filterImages.getOrdering(), filterImages.getFolderName()));
        }
        if (filterImages.getDateTo() != null && filterImages.getDateFrom() != null && filterImages.getOrdering() != null && filterImages.getFolderName() == null) {
            if (filterImages.getOrdering().equals("Newest First")) {
                patientUploadedFilesList.addAll(this.overViewRepository.getPatientFilesBYDateOrderingASC(user.getId(), filterImages.getDateFrom(), filterImages.getDateTo()));
            } else {
                patientUploadedFilesList.addAll(this.overViewRepository.getPatientFilesBYDateOrderingDESC(user.getId(), filterImages.getDateFrom(), filterImages.getDateTo()));
            }
        }
        return patientUploadedFilesList;
    }

    public List<PatientUploadedFiles> getimagesByUserId() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String email = authentication.getName();
        User user = (User)this.userRepository.findByemailAddress(email).get();
        return this.overViewRepository.getImagesByUserId(user.getId());
    }

    public Long getCounts() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String email = authentication.getName();
        User user = (User)this.userRepository.findByemailAddress(email).get();
        return this.overViewRepository.getUserFilesCount(user.getId());
    }

    public void deleteImgByID(int id) {
        this.overViewRepository.deleteImgUploaded(id);
    }
}

